/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.MenuItem;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class Menu {
    private org.eclipse.swt.widgets.Menu mainMenu;
    private Decorations parent;
    private Hashtable itemLookup = new Hashtable();

    protected Menu(Decorations parent) throws Exception {
        this.parent = parent;
        this.mainMenu = new org.eclipse.swt.widgets.Menu(parent, 2);
        if (!Customizing.SETTINGS.getBoolean("application.hidemenu", false)) {
            parent.setMenuBar(this.mainMenu);
        }
        this.load(Application.getManifest().getMenu(), this.mainMenu);
    }

    protected void add(MenuItem menu) throws Exception {
        if (menu == null || this.mainMenu == null) {
            return;
        }
        if (Customizing.SETTINGS.getBoolean("application.menu.hideplugins", false)) {
            return;
        }
        this.load(menu, this.mainMenu);
    }

    private void load(MenuItem element, org.eclipse.swt.widgets.Menu parentMenu) throws Exception {
        int numChilds;
        KeyStroke shortcut;
        if (element == null) {
            return;
        }
        ExtensionRegistry.extend(element);
        Object name = element.getName();
        if (name == null) {
            this.loadChildren(element, parentMenu);
            return;
        }
        if ("-".equals(name)) {
            new org.eclipse.swt.widgets.MenuItem(parentMenu, 2);
            return;
        }
        org.eclipse.swt.widgets.MenuItem item = new org.eclipse.swt.widgets.MenuItem(parentMenu, 64);
        this.itemLookup.put(element, item);
        item.setData("item", (Object)element);
        item.setEnabled(element.isEnabled());
        Image icon = element.getIcon();
        if (icon != null) {
            item.setImage(icon);
        }
        if ((shortcut = SWTUtil.getKeyStroke(element.getShortcut())) != null) {
            item.setAccelerator(shortcut.getModifierKeys() + shortcut.getNaturalKey());
            name = (String)name + "\t" + SWTKeySupport.getKeyFormatterForPlatform().format(shortcut);
        }
        item.setText((String)name);
        GenericIterator i = element.getChildren();
        int n = numChilds = i != null ? i.size() : 0;
        if (element.getAction() != null) {
            if (numChilds > 0) {
                Logger.warn((String)("menu element " + element.getID() + " [" + element.getName() + "] containes action AND children. Skipping action"));
            } else {
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Widget widget = event.widget;
                        if (widget == null || !(widget instanceof org.eclipse.swt.widgets.MenuItem) || widget.isDisposed()) {
                            return;
                        }
                        org.eclipse.swt.widgets.MenuItem item = (org.eclipse.swt.widgets.MenuItem)widget;
                        MenuItem mi = (MenuItem)item.getData("item");
                        if (mi == null) {
                            return;
                        }
                        try {
                            Action a = mi.getAction();
                            if (a == null || !mi.isEnabled()) {
                                return;
                            }
                            Logger.debug((String)("executing menu entry " + mi.getID() + " [" + mi.getName() + "]"));
                            a.handleAction(event);
                        }
                        catch (OperationCanceledException oce) {
                            Logger.debug((String)("operation cancelled: " + oce.getMessage()));
                        }
                        catch (ApplicationException ae) {
                            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getLocalizedMessage(), 1));
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to handle menu action", (Throwable)e);
                            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Ausf\u00fchren des Menu-Eintrags"), 1));
                        }
                    }
                });
            }
        } else if (numChilds > 0) {
            parentMenu = new org.eclipse.swt.widgets.Menu(this.parent, 4);
            item.setMenu(parentMenu);
            this.loadChildren(element, parentMenu);
        } else {
            Logger.warn((String)("menu element " + element.getID() + " [" + element.getName() + "] containes neither action nor children. Skipping element"));
        }
    }

    private void loadChildren(MenuItem element, org.eclipse.swt.widgets.Menu menu) throws Exception {
        GenericIterator childs = element.getChildren();
        if (childs == null || childs.size() == 0) {
            return;
        }
        while (childs.hasNext()) {
            this.load((MenuItem)childs.next(), menu);
        }
    }

    public void update(MenuItem item) throws RemoteException {
        org.eclipse.swt.widgets.MenuItem mi = (org.eclipse.swt.widgets.MenuItem)this.itemLookup.get(item);
        if (mi != null && !mi.isDisposed()) {
            mi.setEnabled(item.isEnabled());
        }
    }
}

